const e=-1!==navigator.userAgent.indexOf("Firefox"),n=e?browser:chrome;if(window.addEventListener("message",(function(e){if(e.data.type&&"redom-devtools"===e.data.source)try{n.runtime.sendMessage(e.data.data?{type:e.data.type,data:e.data.data,origin:e.data.origin}:{type:e.data.type,origin:e.data.origin})}catch(e){}}),!1),e){const e=document.createElement("script");e.textContent='(function () {\n  "use strict";\n\n  const IS_FIREFOX = navigator.userAgent.indexOf("Firefox") !== -1;\n\n  class ReDOMDevtoolsGlobalHook {\n    constructor() {\n      // The set of apps exposed by redom\n      this.apps = window.__REDOM_DEVTOOLS__.apps;\n      // Class definition of an redom Fiber\n      this.Fiber = window.__REDOM_DEVTOOLS__.Fiber;\n      // Same but for RootFiber\n      this.RootFiber = window.__REDOM_DEVTOOLS__.RootFiber;\n      // This is for retrocompatibility purposes since new versions of redom should always expose toRaw and reactive\n      // in __REDOM_DEVTOOLS__\n      this.toRaw = window.__REDOM_DEVTOOLS__.toRaw ?? window.redom?.toRaw;\n      this.reactive = window.__REDOM_DEVTOOLS__.reactive ?? window.redom?.reactive;\n      // Set to keep track of the HTML elements we added to the page\n      this.addedElements = [];\n      // To keep track of the succession order of the render events\n      this.eventId = 0;\n      // Set to keep track of the frame on which this script is loaded\n      this.frame = "top";\n      // Allows to launch a message each time an iframe html element is added to the page\n      const iFrameObserver = new MutationObserver(function (mutationsList) {\n        mutationsList.forEach(function (mutation) {\n          mutation.addedNodes.forEach(function (addedNode) {\n            if (addedNode.tagName == "IFRAME") {\n              // Ensure it is not an empty iframe element\n              if (addedNode.contentDocument) {\n                /*\n                 * This message is intercepted by the content script which relays it to the background script which relays it to the devtools app.\n                 * This process may seem long and indirect but is necessary. This applies to all window.top.postMessage methods in this file.\n                 * More information in the docs: https://developer.chrome.com/docs/extensions/mv3/devtools/#evaluated-scripts-to-devtools\n                 */\n                window.top.postMessage({\n                  source: "redom-devtools",\n                  type: "NewIFrame",\n                  data: addedNode.contentDocument.location.href,\n                });\n              }\n            }\n          });\n        });\n      });\n      iFrameObserver.observe(document.body, { subtree: true, childList: true });\n      this.patchAppsSetMethods();\n      this.recordEvents = false;\n      this.traceRenderings = false;\n      this.traceSubscriptions = false;\n      this.requestedFrame = false;\n      this.enabledSelector = false;\n      this.eventsBatch = [];\n      this.breakpointsClassMap = new Map();\n      this.breakpointsHookMap = new Map();\n      // Object which defines how different types of data should be displayed when passed to the devtools\n      this.serializer = {\n        // Defines how leaf object nodes should be displayed in the extension when inside a bigger structure\n        // This is also used by default when it is a standalone item (like functions, numbers, strings, etc)\n        // The asConstructorName parameter can be passed to change the display of objects and functions to\n        // be their constructor name (useful for prototype, map and set display)\n        serializeItem(value, asConstructorName = false) {\n          if (typeof value === "object") {\n            if (value == null) {\n              return "null";\n            }\n            if (asConstructorName) {\n              return value.constructor.name;\n            }\n            if (value instanceof Array) {\n              return "Array(" + value.length + ")";\n            }\n            return "{...}";\n          } else if (typeof value === "undefined") {\n            return "undefined";\n          } else if (typeof value === "string") {\n            return JSON.stringify(value);\n          } else if (typeof value === "function") {\n            if (asConstructorName) {\n              return value.constructor.name;\n            }\n            let functionString = value.toString();\n            if (functionString.startsWith("class")) {\n              return "class " + value.name;\n            } else {\n              // This replaces the body of any function with curly braces by ...\n              const regex = /\\{(?![^()]*\\))(.*?)\\}(?![^{}]*\\})/s;\n              return functionString.replace(regex, "{...}");\n            }\n          } else {\n            let valueAsString = value.toString();\n            if (asConstructorName && valueAsString.length > 10) {\n              valueAsString = valueAsString.substring(0, 8) + "...";\n            }\n            return valueAsString;\n          }\n        },\n        array(arr) {\n          const result = [];\n          let length = 0;\n          for (const item of arr) {\n            if (length > 25) {\n              result.push("...");\n              break;\n            }\n            const element = this.serializeItem(item);\n            length += element.length;\n            result.push(element);\n          }\n          return "[" + result.join(", ") + "]";\n        },\n        object(obj) {\n          const result = [];\n          let length = 0;\n          if (obj instanceof String) {\n            result[0] = `\'${obj.toString()}\'`;\n          } else if (obj instanceof Array) {\n            return `${obj.constructor.name} ${this.array([...obj])}`;\n          } else if (obj instanceof Number) {\n            result[0] = obj.toString();\n          } else {\n            for (const key of Reflect.ownKeys(obj)) {\n              if (length > 25) {\n                result.push("...");\n                break;\n              }\n              let element;\n              if (Object.getOwnPropertyDescriptor(obj, key).hasOwnProperty("get")) {\n                element = key.toString() + ": (...)";\n              } else {\n                element = key.toString() + ": " + this.serializeItem(obj[key]);\n              }\n              length += element.length;\n              result.push(element);\n            }\n            for (const key of Object.getOwnPropertySymbols(obj)) {\n              if (length > 25) {\n                result.push("...");\n                break;\n              }\n              const element = key.toString() + ": " + this.serializeItem(obj[key]);\n              length += element.length;\n              result.push(element);\n            }\n          }\n          if (obj.constructor && obj.constructor.name !== "Object") {\n            return obj.constructor.name + " {" + result.join(", ") + "}";\n          }\n          return "{" + result.join(", ") + "}";\n        },\n        map(obj) {\n          const result = [];\n          let length = 0;\n          for (const [key, value] of obj.entries()) {\n            if (length > 25) {\n              result.push("...");\n              break;\n            }\n            const element =\n              this.serializeItem(key, true) + " => " + this.serializeItem(value, true);\n            length += element.length;\n            result.push(element);\n          }\n          return "Map(" + obj.size + "){" + result.join(", ") + "}";\n        },\n        ["map entry"](obj) {\n          return (\n            "{" + this.serializeItem(obj[0], true) + " => " + this.serializeItem(obj[1], true) + "}"\n          );\n        },\n        set(obj) {\n          const result = [];\n          let length = 0;\n          for (const value of obj) {\n            if (length > 25) {\n              result.push("...");\n              break;\n            }\n            const element = this.serializeItem(value, false);\n            length += element.length;\n            result.push(element);\n          }\n          return "Set(" + obj.size + "){" + result.join(", ") + "}";\n        },\n        // Returns a shortened string version of a collection of properties for display purposes\n        // Shortcut for serializeItem when it is a standalone item\n        serializeContent(item, type) {\n          if (this[type]) {\n            return this[type](item);\n          }\n          return this.serializeItem(item);\n        },\n      };\n    }\n\n    initDevtools(frame = "top") {\n      if (!this.devtoolsInit) {\n        document.addEventListener("mouseover", this.HTMLSelector, { capture: true });\n        this.frame = frame;\n        const self = this;\n        // Flush the events batcher when a root render is completed\n        const original_Complete = self.RootFiber.prototype.complete;\n        self.RootFiber.prototype.complete = function () {\n          original_Complete.call(this, ...arguments);\n          const path = self.getComponentPath(this.node);\n          //Add a functionnality to the complete function which sends a message to the window every time it is triggered.\n          window.top.postMessage({\n            source: "redom-devtools",\n            type: "Complete",\n            data: path,\n            origin: { frame: self.frame },\n          });\n          if (self.recordEvents) {\n            window.top.postMessage({\n              source: "redom-devtools",\n              type: "Event",\n              data: self.eventsBatch,\n            });\n            self.eventsBatch = [];\n          }\n        };\n        this.devtoolsInit = true;\n      }\n    }\n    // Modify the methods of the apps set in order to send a message each time it is modified.\n    patchAppsSetMethods() {\n      const originalAdd = this.apps.add;\n      const originalDelete = this.apps.delete;\n      this.apps.add = function () {\n        originalAdd.call(this, ...arguments);\n        window.top.postMessage({\n          source: "redom-devtools",\n          type: "RefreshApps",\n        });\n      };\n      this.apps.delete = function () {\n        originalDelete.call(this, ...arguments);\n        window.top.postMessage({\n          source: "redom-devtools",\n          type: "RefreshApps",\n        });\n      };\n    }\n\n    // Modify methods of each app so that it triggers messages on each flush and component render\n    patchAppMethods() {\n      let app;\n      for (const appItem of this.apps) {\n        if (appItem.root) {\n          app = appItem;\n        }\n      }\n      if (!app.root) {\n        return;\n      }\n      const self = this;\n      const originalFlush = app.scheduler.constructor.prototype.flush;\n      let inFlush = false;\n      let _render = false;\n      app.scheduler.constructor.prototype.flush = function () {\n        // Used to know when a render is triggered inside the flush method or not\n        inFlush = true;\n        originalFlush.call(this, ...arguments);\n        inFlush = false;\n      };\n      const originalRender = self.Fiber.prototype.render;\n      self.Fiber.prototype.render = function () {\n        const id = self.eventId++;\n        _render = false;\n        let flushed = false;\n        // We know if a render comes from flush before calling the render method\n        if (this instanceof self.RootFiber && inFlush) {\n          flushed = true;\n        }\n\n        // patch the renderFn function from the node to only measure the time\n        // spent in the template, not in additional work, such as flushing scheduler\n        const node = this.node;\n        const nodeRenderFn = node.renderFn;\n        let time = 0;\n        this.node.renderFn = function () {\n          const before = performance.now();\n          const result = nodeRenderFn.call(this);\n          time = performance.now() - before;\n          // unpatch the node render function\n          node.renderFn = nodeRenderFn;\n          return result;\n        };\n\n        originalRender.call(this, ...arguments);\n        if (_render && self.traceRenderings && this instanceof self.RootFiber) {\n          console.groupCollapsed(`Rendering <${this.node.name}>`);\n          console.trace();\n          console.groupEnd();\n        }\n        if (self.recordEvents) {\n          const path = self.getComponentPath(this.node);\n          // if the render comes from flush\n          if (flushed) {\n            self.eventsBatch.push({\n              type: "render (flushed)",\n              component: this.node.name,\n              key: this.node.parentKey ? this.node.parentKey : "",\n              path: path,\n              time: time,\n              id: id,\n            });\n            // if _render is called, it is a proper render (and not a delayed one)\n          } else if (_render) {\n            // A render on a RootFiber is a root render and can propagate other renders to its children\n            if (this instanceof self.RootFiber) {\n              self.eventsBatch.push({\n                type: this.deep ? "render (deep)" : "render",\n                component: this.node.name,\n                key: this.node.parentKey ? this.node.parentKey : "",\n                path: path,\n                time: time,\n                id: id,\n              });\n              // if the node status is NEW, the node has been created just before rendering\n            } else if (this.node.status === 0) {\n              self.eventsBatch.push({\n                type: "create",\n                component: this.node.name,\n                key: this.node.parentKey ? this.node.parentKey : "",\n                path: path,\n                time: time,\n                id: id,\n              });\n              // else it is an update\n            } else {\n              self.eventsBatch.push({\n                type: "update",\n                component: this.node.name,\n                key: this.node.parentKey ? this.node.parentKey : "",\n                path: path,\n                time: time,\n                id: id,\n              });\n            }\n            // _render has not been called so it is a delayed render that could be flushed later on\n          } else {\n            self.eventsBatch.push({\n              type: "render (delayed)",\n              component: this.node.name,\n              key: this.node.parentKey ? this.node.parentKey : "",\n              path: path,\n              time: time,\n              id: id,\n            });\n          }\n        }\n      };\n      const original_Render = self.Fiber.prototype._render;\n      self.Fiber.prototype._render = function () {\n        _render = true;\n        original_Render.call(this, ...arguments);\n      };\n      // Signals when a component is destroyed\n      const originalDestroy = app.root.constructor.prototype._destroy;\n      app.root.constructor.prototype._destroy = function () {\n        if (self.recordEvents) {\n          const path = self.getComponentPath(this);\n          const event = {\n            type: "destroy",\n            component: this.name,\n            key: this.parentKey,\n            path: path,\n            time: 0,\n            id: self.eventId++,\n          };\n          self.eventsBatch.push(event);\n          const before = performance.now();\n          originalDestroy.call(this, ...arguments);\n          event.time = performance.now() - before;\n        } else {\n          originalDestroy.call(this, ...arguments);\n        }\n      };\n    }\n\n    // patch reactivity system to activate subscription tracing\n    patchReactivity() {\n      // i am simultaneously proud and ashamed of this code...\n      const WeakMapGet = WeakMap.prototype.get;\n      const MapGet = Map.prototype.get;\n      const SetAdd = Set.prototype.add;\n      const self = this;\n\n      let callbacksToTargets;\n      let targetToKeysToCallbacks;\n\n      // Step 1: extract internal values\n      const obj = self.reactive({}, () => {});\n      let count = 0;\n      WeakMap.prototype.get = function () {\n        count++;\n        if (count === 1) {\n          targetToKeysToCallbacks = this;\n        }\n        if (count === 3) {\n          callbacksToTargets = this;\n          WeakMap.prototype.get = WeakMapGet;\n        }\n        return WeakMapGet.call(this, ...arguments);\n      };\n      obj.a;\n\n      // Step 2: patch these objects\n      let key;\n      function getKey(_key) {\n        key = _key;\n        return MapGet.call(this, _key);\n      }\n\n      targetToKeysToCallbacks.get = function (target) {\n        const keyToCallbacks = WeakMapGet.call(this, target);\n        if (keyToCallbacks) {\n          keyToCallbacks.get = getKey;\n        }\n        return keyToCallbacks;\n      };\n\n      function addTarget(target) {\n        // HERE\n        if (self.traceSubscriptions && !this.has(target)) {\n          console.groupCollapsed(`Observing:`, key, target);\n          console.trace();\n          console.groupEnd();\n        }\n        return SetAdd.call(this, target);\n      }\n      callbacksToTargets.get = function (callback) {\n        const targets = WeakMapGet.call(this, callback);\n        if (targets) {\n          targets.add = addTarget;\n        }\n        return targets;\n      };\n    }\n\n    toggleTracing(value) {\n      if (value) {\n        this.patchAppMethods();\n        this.patchAppMethods = () => {}; // to only patch once\n      }\n      this.traceRenderings = value;\n      return this.traceRenderings;\n    }\n\n    toggleSubscriptionTracing(value) {\n      if (value) {\n        this.patchReactivity();\n        this.patchReactivity = () => {}; // to only patch once\n      }\n      this.traceSubscriptions = value;\n      return value;\n    }\n    // Enables/disables the recording of the render/destroy events based on value\n    toggleEventsRecording(value, index) {\n      if (value) {\n        this.patchAppMethods();\n        this.patchAppMethods = () => {}; // to only patch once\n      }\n      this.recordEvents = value;\n      this.eventId = index;\n      return this.recordEvents;\n    }\n\n    // Reset the event ids (the events on devtools side will be cleared at the same time)\n    resetEvents() {\n      this.eventId = 0;\n    }\n\n    // Get the urls of all iframes present on the page\n    getIFrameUrls() {\n      let frames = [];\n      for (const frame of document.querySelectorAll("iframe")) {\n        frames.push(frame.contentDocument.location.href);\n      }\n      return frames;\n    }\n\n    // Draws a highlighting rectangle on the specified html element and displays its dimensions and the specified name in a box\n    highlightElements(elements, name) {\n      this.removeHighlights();\n\n      if (elements.length === 0) {\n        return;\n      }\n\n      let minTop = Number.MAX_SAFE_INTEGER;\n      let minLeft = Number.MAX_SAFE_INTEGER;\n      let maxBottom = Number.MIN_SAFE_INTEGER;\n      let maxRight = Number.MIN_SAFE_INTEGER;\n\n      for (const element of elements) {\n        let rect;\n        // Since this function accepts text nodes, we need to create a range to get the position and dimensions\n        if (element instanceof Text) {\n          const range = document.createRange();\n          range.selectNode(element);\n          rect = range.getBoundingClientRect();\n        } else {\n          rect = element.getBoundingClientRect();\n        }\n\n        const top = rect.top;\n        const left = rect.left;\n        const bottom = top + rect.height;\n        const right = left + rect.width;\n\n        minTop = Math.min(minTop, top);\n        minLeft = Math.min(minLeft, left);\n        maxBottom = Math.max(maxBottom, bottom);\n        maxRight = Math.max(maxRight, right);\n\n        const width = right - left;\n        const height = bottom - top;\n\n        if (element instanceof HTMLElement) {\n          const marginTop = parseInt(getComputedStyle(element).marginTop);\n          const marginRight = parseInt(getComputedStyle(element).marginRight);\n          const marginBottom = parseInt(getComputedStyle(element).marginBottom);\n          const marginLeft = parseInt(getComputedStyle(element).marginLeft);\n\n          const paddingTop = parseInt(getComputedStyle(element).paddingTop);\n          const paddingRight = parseInt(getComputedStyle(element).paddingRight);\n          const paddingBottom = parseInt(getComputedStyle(element).paddingBottom);\n          const paddingLeft = parseInt(getComputedStyle(element).paddingLeft);\n\n          const highlight = document.createElement("div");\n          highlight.style.top = `${top}px`;\n          highlight.style.left = `${left}px`;\n          highlight.style.width = `${width}px`;\n          highlight.style.height = `${height}px`;\n          highlight.style.boxSizing = "border-box";\n          highlight.style.position = "fixed";\n          highlight.style.backgroundColor = "rgba(15, 139, 245, 0.4)";\n          highlight.style.borderStyle = "solid";\n          highlight.style.borderWidth = `${paddingTop}px ${paddingRight}px ${paddingBottom}px ${paddingLeft}px`;\n          highlight.style.borderColor = "rgba(65, 196, 68, 0.4)";\n          highlight.style.zIndex = "10000";\n          highlight.style.pointerEvents = "none";\n          document.body.appendChild(highlight);\n          this.addedElements.push(highlight);\n\n          const highlightMargins = document.createElement("div");\n          highlightMargins.style.top = `${top - marginTop}px`;\n          highlightMargins.style.left = `${left - marginLeft}px`;\n          highlightMargins.style.width = `${width + marginLeft + marginRight}px`;\n          highlightMargins.style.height = `${height + marginBottom + marginTop}px`;\n          highlightMargins.style.position = "fixed";\n          highlightMargins.style.borderStyle = "solid";\n          highlightMargins.style.boxSizing = "border-box";\n          highlightMargins.style.borderWidth = `${marginTop}px ${marginRight}px ${marginBottom}px ${marginLeft}px`;\n          highlightMargins.style.borderColor = "rgba(241, 179, 121, 0.4)";\n          highlightMargins.style.zIndex = "10000";\n          highlightMargins.style.pointerEvents = "none";\n          document.body.appendChild(highlightMargins);\n          this.addedElements.push(highlightMargins);\n          // In case the element is a range because a text node was passed\n        } else {\n          const highlight = document.createElement("div");\n          highlight.style.top = `${top}px`;\n          highlight.style.left = `${left}px`;\n          highlight.style.width = `${width}px`;\n          highlight.style.height = `${height}px`;\n          highlight.style.boxSizing = "border-box";\n          highlight.style.position = "fixed";\n          highlight.style.backgroundColor = "rgba(15, 139, 245, 0.4)";\n          highlight.style.zIndex = "10000";\n          highlight.style.pointerEvents = "none";\n          document.body.appendChild(highlight);\n          this.addedElements.push(highlight);\n        }\n      }\n\n      const width = maxRight - minLeft;\n      const height = maxBottom - minTop;\n\n      const detailsBox = document.createElement("div");\n      detailsBox.className = "redom-devtools-detailsBox";\n      detailsBox.innerHTML = `\n      <div style="color: #ffc107; display: inline;">${name} </div><div style="color: white; display: inline;">${width.toFixed(\n        2\n      )}px x ${height.toFixed(2)}px</div>\n      `;\n      detailsBox.style.position = "fixed";\n      detailsBox.style.backgroundColor = "black";\n      detailsBox.style.padding = "5px";\n      detailsBox.style.zIndex = "10000";\n      detailsBox.style.pointerEvents = "none";\n      detailsBox.style.display = "inline";\n      document.body.appendChild(detailsBox);\n      this.addedElements.push(detailsBox);\n\n      const viewportWidth = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);\n      const viewportHeight = Math.max(\n        document.documentElement.clientHeight,\n        window.innerHeight || 0\n      );\n      const detailsBoxRect = detailsBox.getBoundingClientRect();\n      let detailsBoxTop = minTop + height + 5;\n      let detailsBoxLeft = minLeft;\n      if (detailsBoxTop + detailsBoxRect.height > viewportHeight) {\n        detailsBoxTop = minTop - detailsBoxRect.height - 5;\n        if (detailsBoxTop < 0) {\n          detailsBoxTop = minTop;\n        }\n      }\n      if (detailsBoxLeft + detailsBoxRect.width > viewportWidth) {\n        detailsBoxLeft = minLeft - detailsBoxRect.width - 5;\n      }\n      detailsBox.style.top = `${detailsBoxTop}px`;\n      detailsBox.style.left = `${detailsBoxLeft + 5}px`;\n    }\n\n    // Remove all elements drawn by the HighlightElement function\n    removeHighlights = () => {\n      for (const el of this.addedElements) {\n        el.remove();\n      }\n      this.addedElements = [];\n    };\n\n    // Identify the hovered component based on the corresponding DOM element and send the Select message\n    // when the target changes\n    HTMLSelector = (ev) => {\n      if (this.enabledSelector) {\n        const target = ev.target;\n        if (!this.currentSelectedElement || !target.isEqualNode(this.currentSelectedElement)) {\n          const path = this.getElementPath(target);\n          this.highlightComponent(path);\n          this.currentSelectedElement = target;\n          window.top.postMessage({\n            source: "redom-devtools",\n            type: "SelectElement",\n            data: path,\n          });\n        }\n      } else {\n        this.removeHighlights();\n      }\n    };\n\n    // Activate the HTML selector tool\n    enableHTMLSelector() {\n      this.enabledSelector = true;\n      document.addEventListener("click", this.disableHTMLSelector, { capture: true });\n      document.addEventListener("scroll", this.removeHighlights, { capture: true });\n    }\n\n    // Diasble the HTML selector tool\n    disableHTMLSelector = (ev = undefined) => {\n      this.enabledSelector = false;\n      if (ev) {\n        if (!ev.isTrusted) {\n          return;\n        }\n        ev.stopPropagation();\n        ev.preventDefault();\n      }\n      this.removeHighlights();\n      document.removeEventListener("click", this.disableHTMLSelector, { capture: true });\n      document.removeEventListener("scroll", this.removeHighlights, { capture: true });\n      window.top.postMessage({\n        source: "redom-devtools",\n        type: "StopSelector",\n      });\n    };\n\n    // Returns the object specified by the path starting from the topParent object\n    getObject(topParent, path) {\n      let obj = topParent;\n      if (path.length === 0) {\n        return obj;\n      }\n      for (const key of path) {\n        switch (key.type) {\n          case "prototype":\n            obj = Object.getPrototypeOf(obj);\n            break;\n          // We will be handling maps and sets entries as arrays to keep things stable\n          case "set entries":\n          case "map entries":\n            obj = [...obj];\n            break;\n          // Kind of tricky structure-wise but the set entry already is the object itself so this is\n          // only useful for display purpose in the devtools.\n          case "set value":\n            obj = obj;\n            break;\n          // A map entry is a two items array with the key and the value so indexes 0 and 1\n          case "map key":\n            obj = obj[0];\n            break;\n          case "map value":\n            obj = obj[1];\n            break;\n          case "getter":\n            // When the item is a getter, get its value.\n            try {\n              obj = Object.getOwnPropertyDescriptor(obj, key.value).get.call(obj);\n            } catch (e) {\n              obj = "Exception: " + e.toString();\n            }\n            break;\n          case "prototype getter":\n          case "set entry":\n          case "map entry":\n          case "item":\n            // When the item is a symbol, we make sure it is the right one by using the index on the\n            // Object.getOwnPropertySymbols array.\n            if (key.hasOwnProperty("symbolIndex") && key.symbolIndex >= 0) {\n              const symbol = Object.getOwnPropertySymbols(obj)[key.symbolIndex];\n              if (symbol) {\n                obj = obj[symbol];\n              }\n            } else if (Object.getOwnPropertyDescriptor(obj, key.value)?.hasOwnProperty("get")) {\n              try {\n                obj = Object.getOwnPropertyDescriptor(obj, key.value).get;\n              } catch (e) {\n                obj = "Exception: " + e.toString();\n              }\n            } else {\n              try {\n                obj = obj[key.value];\n              } catch (e) {\n                obj = "Exception: " + e.toString();\n              }\n            }\n        }\n        if (obj) {\n          obj = this.toRaw(obj);\n        }\n      }\n      return obj;\n    }\n\n    // Returns the asked property given its global path\n    getObjectProperty(path) {\n      // Just return the corresponding app if path is of length 1 and not simplified\n      if (path.length === 1 && !isNaN(path[0])) {\n        return [...this.apps][path[0]];\n      }\n      // Path to the component node is only strings, becomes objects for properties\n      const index = path.findIndex((key) => typeof key !== "string");\n      if (index === -1) {\n        return this.getComponentNode(path);\n      }\n      const componentNode = this.getComponentNode(index === 1 ? [path[0]] : path.slice(0, index));\n      if (componentNode) {\n        return this.getObject(componentNode, path.slice(index));\n      }\n      return "Exception: component not found";\n    }\n\n    // Returns a modified version of an object node that has compatible format with the devtools ObjectTreeElement component\n    // parentObj is the parent of the node, key is the path key of the node, type is where the object belongs to (props, env, instance, ...),\n    // oldBranch is supposedly the same final node in the previous version of the tree and oldTree is the complete old component details\n    serializeObjectChild(parentObj, key, depth, type, path, oldBranch, oldTree) {\n      let obj;\n      let child = {\n        depth: depth,\n        toggled: false,\n        objectType: type,\n        hasChildren: false,\n      };\n      if (oldBranch?.toggled) {\n        child.toggled = true;\n      }\n      child.path = path.concat([key]);\n      child.children = [];\n      switch (key.type) {\n        case "prototype":\n          child.name = "[[Prototype]]";\n          child.contentType = "object";\n          child.content = this.serializer.serializeItem(Object.getPrototypeOf(parentObj), true);\n          child.hasChildren = true;\n          if (!oldTree && type === "env" && Object.getPrototypeOf(parentObj) !== Object.prototype) {\n            child.toggled = true;\n          }\n          break;\n        case "set entries":\n        case "map entries":\n          child.name = "[[Entries]]";\n          child.content = "";\n          child.contentType = "array";\n          child.hasChildren = true;\n          break;\n        case "set value":\n          child.name = "value";\n          obj = parentObj;\n          break;\n        case "map key":\n          child.name = "key";\n          obj = parentObj[0];\n          break;\n        case "map value":\n          child.name = "value";\n          obj = parentObj[1];\n          break;\n        case "getter":\n          child.name = key.value;\n          obj = parentObj[key.value];\n          break;\n        case "prototype getter":\n        case "set entry":\n        case "map entry":\n        case "item":\n          if (Object.getOwnPropertyDescriptor(parentObj, key.value)?.hasOwnProperty("get")) {\n            child.name = "get " + key.value;\n            obj = Object.getOwnPropertyDescriptor(parentObj, key.value).get;\n          } else {\n            child.name = key.value;\n            if (typeof key.value === "symbol") {\n              child.name = key.value.toString();\n              obj = parentObj[key.value];\n              child.path[child.path.length - 1].symbolIndex = Object.getOwnPropertySymbols(\n                parentObj\n              ).findIndex((sym) => sym === key.value);\n              child.path[child.path.length - 1].value = key.value.toString();\n            } else if (key.hasOwnProperty("symbolIndex")) {\n              obj = parentObj[Object.getOwnPropertySymbols(parentObj)[key.symbolIndex]];\n            } else {\n              obj = parentObj[key.value];\n            }\n          }\n          if (key.type === "map entry") {\n            child.contentType = "array";\n            child.hasChildren = obj.length > 0;\n            child.content = this.serializer.serializeContent(obj, key.type);\n          }\n          break;\n      }\n      if (!child.contentType) {\n        if (obj === null) {\n          child.content = "null";\n          child.contentType = "object";\n          child.hasChildren = false;\n        } else if (obj === undefined) {\n          child.content = "undefined";\n          child.contentType = "undefined";\n          child.hasChildren = false;\n        } else {\n          obj = this.toRaw(obj);\n          switch (true) {\n            case obj instanceof Map:\n              child.contentType = "map";\n              child.hasChildren = true;\n              break;\n            case obj instanceof Set:\n              child.contentType = "set";\n              child.hasChildren = true;\n              break;\n            case obj.constructor?.name === "Array":\n              child.contentType = "array";\n              child.hasChildren = obj.length > 0;\n              break;\n            case typeof obj === "function":\n              child.contentType = "function";\n              child.hasChildren = true;\n              break;\n            case typeof obj === "object":\n              child.contentType = "object";\n              child.hasChildren =\n                Object.keys(obj).length > 0 ||\n                Object.getOwnPropertySymbols(obj).length > 0 ||\n                obj.constructor.name !== "Object";\n              break;\n            default:\n              child.contentType = typeof obj;\n              child.hasChildren = false;\n          }\n          if (key.type === "set entry") {\n            child.content = this.serializer.serializeItem(obj, true);\n          } else {\n            child.content = this.serializer.serializeContent(obj, child.contentType);\n          }\n        }\n      }\n      if (child.toggled) {\n        child.children = this.loadObjectChildren(\n          child.path,\n          child.depth,\n          child.contentType,\n          child.objectType,\n          oldTree\n        );\n      }\n      this.addHighlightedKeys(child);\n      return child;\n    }\n\n    // returns the serialized node corresponding to its path in the serialized tree\n    getObjectInOldTree(oldTree, completePath, objType) {\n      const objPathIndex = completePath.findIndex((key) => typeof key !== "string");\n      let path = completePath.slice(objPathIndex);\n      let obj;\n      if (objType === "subscription") {\n        const subscriptionPath = completePath.slice(0, objPathIndex + 3);\n        obj = oldTree.subscriptions.children.find(\n          (child) => JSON.stringify(child.target.path) === JSON.stringify(subscriptionPath)\n        ).target;\n        path = path.slice(3);\n      } else {\n        // Everything here is in component if it is not an app so remove this key of the path in the former case\n        if (objPathIndex > 1) {\n          path.shift();\n        }\n        // the value is either "props" or "env" here\n        if (objType !== "instance" && objType !== "hook") {\n          obj = oldTree[path[0].value].children;\n          path.shift();\n          // there is nothing otherwise but extension side it is in instance\n        } else if (objType === "instance") {\n          obj = oldTree.instance.children;\n        } else {\n          obj = oldTree.hooks.children;\n          path.shift();\n        }\n        // the first element here is directly in an array instead of a children array\n        obj = obj[path[0].childIndex];\n        path.shift();\n      }\n      // just follow the indexes in the rest of the path\n      for (const key of path) {\n        obj = obj.children[key.childIndex];\n      }\n      return obj;\n    }\n    // Returns a serialized version of the children properties of the specified component\'s property given its path.\n    loadObjectChildren(path, depth, contentType, objType, oldTree) {\n      const children = [];\n      depth = depth + 1;\n      let obj = this.getObjectProperty(path);\n      let oldBranch = oldTree && this.getObjectInOldTree(oldTree, path, objType);\n      if (!obj) {\n        return [];\n      }\n      let index = 0;\n      const lastKey = path.at(-1);\n      let prototype;\n      if (lastKey.type.includes("entry")) {\n        if (lastKey.type === "map entry") {\n          const mapKey = this.serializeObjectChild(\n            obj,\n            { type: "map key", childIndex: 0 },\n            depth,\n            objType,\n            path,\n            oldBranch?.children[0],\n            oldTree\n          );\n          children.push(mapKey);\n          const mapValue = this.serializeObjectChild(\n            obj,\n            { type: "map value", childIndex: 1 },\n            depth,\n            objType,\n            path,\n            oldBranch?.children[1],\n            oldTree\n          );\n          children.push(mapValue);\n        } else if (lastKey.type === "set entry") {\n          const setValue = this.serializeObjectChild(\n            obj,\n            { type: "set value", childIndex: 0 },\n            depth,\n            objType,\n            path,\n            oldBranch?.children[0],\n            oldTree\n          );\n          children.push(setValue);\n        }\n        return children;\n      }\n      switch (contentType) {\n        case "array":\n          if (lastKey.type.includes("entries")) {\n            for (; index < obj.length; index++) {\n              const child = this.serializeObjectChild(\n                obj,\n                {\n                  type: lastKey.type.replace("entries", "entry"),\n                  value: index,\n                  childIndex: children.length,\n                },\n                depth,\n                objType,\n                path,\n                oldBranch?.children[index],\n                oldTree\n              );\n              if (child) {\n                children.push(child);\n              }\n            }\n          } else {\n            for (; index < obj.length; index++) {\n              const child = this.serializeObjectChild(\n                obj,\n                { type: "item", value: index, childIndex: children.length },\n                depth,\n                objType,\n                path,\n                oldBranch?.children[index],\n                oldTree\n              );\n              if (child) {\n                children.push(child);\n              }\n            }\n          }\n          break;\n        case "set":\n        case "map":\n          const entries = this.serializeObjectChild(\n            obj,\n            { type: contentType + " entries", value: "[[Entries]]", childIndex: children.length },\n            depth,\n            objType,\n            path,\n            oldBranch?.children[index],\n            oldTree\n          );\n          if (entries) {\n            children.push(entries);\n            index++;\n          }\n          Reflect.ownKeys(obj).forEach((key) => {\n            const child = this.serializeObjectChild(\n              obj,\n              { type: "item", value: key, childIndex: children.length },\n              depth,\n              objType,\n              path,\n              oldBranch?.children[index],\n              oldTree\n            );\n            if (child) {\n              children.push(child);\n            }\n            index++;\n          });\n          break;\n        case "object":\n        case "function":\n          Reflect.ownKeys(obj)\n            .sort(compareKeys)\n            .forEach((key) => {\n              if (\n                key !== "__proto__" &&\n                Object.getOwnPropertyDescriptor(obj, key).hasOwnProperty("get")\n              ) {\n                let child = {\n                  name: key,\n                  depth: depth,\n                  toggled: false,\n                  objectType: objType,\n                  path: [...path, { type: "getter", value: key, childIndex: children.length }],\n                  contentType: "getter",\n                  content: "(...)",\n                  hasChildren: false,\n                  children: [],\n                };\n                children.push(child);\n              }\n              const child = this.serializeObjectChild(\n                obj,\n                { type: "item", value: key, childIndex: children.length },\n                depth,\n                objType,\n                path,\n                oldBranch?.children[index],\n                oldTree\n              );\n              if (child) {\n                children.push(child);\n              }\n              index++;\n            });\n      }\n      let proto = Object.getPrototypeOf(obj);\n      while (proto) {\n        Reflect.ownKeys(proto).forEach((key) => {\n          if (\n            key !== "__proto__" &&\n            Object.getOwnPropertyDescriptor(proto, key).hasOwnProperty("get")\n          ) {\n            let child = {\n              name: key,\n              depth: depth,\n              toggled: false,\n              objectType: objType,\n              path: [\n                ...path,\n                { type: "prototype getter", value: key, childIndex: children.length },\n              ],\n              contentType: "getter",\n              content: "(...)",\n              hasChildren: false,\n              children: [],\n            };\n            children.push(child);\n          }\n        });\n        proto = Object.getPrototypeOf(proto);\n      }\n      if (obj.__proto__) {\n        prototype = this.serializeObjectChild(\n          obj,\n          { type: "prototype", childIndex: children.length },\n          depth,\n          objType,\n          path,\n          oldBranch?.children.at(-1),\n          oldTree\n        );\n        children.push(prototype);\n      }\n      return children;\n    }\n    // Returns the Component node given its path and the root component node\n    getComponentNode(path) {\n      // All paths that consists in an array containing a single stringified number lead to an app\n      if (path.length === 1 && !isNaN(path[0])) {\n        return [...this.apps][path[0]];\n      }\n      let node;\n      // If the path is longer and its first item is indeed an app number, it is a regular path\n      if (!isNaN(path[0])) {\n        // The second element in the path will always be the root of the app\n        node = [...this.apps][path[0]]?.root;\n        if (!node) {\n          return null;\n        }\n        for (let i = 2; i < path.length; i++) {\n          // From this point onwards, it is an object path inside the component node\n          if (typeof path[i] !== "string") {\n            break;\n          }\n          if (node.children.hasOwnProperty(path[i])) {\n            node = node.children[path[i]];\n          } else {\n            return null;\n          }\n        }\n        // If the first path item is a more complex string, it is a simplified path where elements\n        // are a series of component names and indexes separated by slashes\n      } else {\n        const simplifiedPathArray = path[0].split("/");\n        node = [...this.apps][simplifiedPathArray[0]]?.root;\n        if (node.name !== simplifiedPathArray[1]) {\n          return null;\n        }\n        for (let i = 2; i < simplifiedPathArray.length; i += 2) {\n          const key = Reflect.ownKeys(node.children)[simplifiedPathArray[i]];\n          node = node.children[key];\n          if (node.name !== simplifiedPathArray[i + 1]) {\n            return null;\n          }\n        }\n      }\n      return node;\n    }\n    // Apply manual render to the specified component\n    refreshComponent(path) {\n      const componentNode = this.getComponentNode(path);\n      componentNode.render();\n    }\n    // Returns the component\'s details given its path\n    getComponentDetails(path = null, oldTree = null) {\n      let component = {};\n      if (!path) {\n        path = this.getElementPath($0);\n      }\n      component.path = path;\n      let node = this.getComponentNode(path) || [...this.apps].find((app) => app.root)?.root;\n      if (!node) {\n        return null;\n      }\n      // A path with only the app index indicates that the component is an App instead\n      const isApp = path.length === 1;\n      if (isApp) {\n        component.version = node.__proto__.constructor?.version\n          ? node.__proto__.constructor.version\n          : "<2.0.8";\n      }\n      // Load props of the component\n      const props = isApp ? node.props : node.component.props;\n      component.props = { toggled: oldTree ? oldTree.props.toggled : true, children: [] };\n      component.name = isApp\n        ? node?.name\n          ? `App (${node.name})`\n          : "App " + (Number(path[0]) + 1)\n        : node.component.constructor.name;\n      const propsPath = isApp\n        ? [...path, { type: "item", value: "props" }]\n        : [...path, { type: "item", value: "component" }, { type: "item", value: "props" }];\n      Reflect.ownKeys(props)\n        .sort(compareKeys)\n        .forEach((key) => {\n          let oldBranch = oldTree?.props.children[component.props.children.length];\n          const property = this.serializeObjectChild(\n            props,\n            { type: "item", value: key, childIndex: component.props.children.length },\n            0,\n            "props",\n            propsPath,\n            oldBranch,\n            oldTree\n          );\n          if (property) {\n            component.props.children.push(property);\n          }\n        });\n      // Load env of the component\n      const env = isApp ? node.env : node.component.env;\n      component.env = { toggled: oldTree ? oldTree.env.toggled : false, children: [] };\n      const envPath = isApp\n        ? [...path, { type: "item", value: "env" }]\n        : [...path, { type: "item", value: "component" }, { type: "item", value: "env" }];\n      Reflect.ownKeys(env)\n        .sort(compareKeys)\n        .forEach((key) => {\n          let oldBranch = oldTree?.env.children[component.env.children.length];\n          const envElement = this.serializeObjectChild(\n            env,\n            { type: "item", value: key, childIndex: component.env.children.length },\n            0,\n            "env",\n            envPath,\n            oldBranch,\n            oldTree\n          );\n          if (envElement) {\n            component.env.children.push(envElement);\n          }\n        });\n      // Load env getters\n      let obj = Object.getPrototypeOf(env);\n      Reflect.ownKeys(obj).forEach((key) => {\n        if (\n          key !== "__proto__" &&\n          Object.getOwnPropertyDescriptor(obj, key).hasOwnProperty("get")\n        ) {\n          let child = {\n            name: key,\n            depth: 0,\n            toggled: false,\n            objectType: "env",\n            path: [\n              ...envPath,\n              { type: "prototype getter", value: key, childIndex: component.env.children.length },\n            ],\n            contentType: "getter",\n            content: "(...)",\n            hasChildren: false,\n            children: [],\n          };\n          component.env.children.push(child);\n        }\n      });\n      const envPrototype = this.serializeObjectChild(\n        env,\n        { type: "prototype", childIndex: component.env.children.length },\n        0,\n        "env",\n        envPath,\n        oldTree?.env[component.env.children.length],\n        oldTree\n      );\n      component.env.children.push(envPrototype);\n      // Load instance of the component\n      const instance = isApp ? node : node.component;\n      component.instance = { toggled: oldTree ? oldTree.instance.toggled : true, children: [] };\n      const instancePath = isApp ? path : [...path, { type: "item", value: "component" }];\n      Reflect.ownKeys(instance)\n        .sort(compareKeys)\n        .forEach((key) => {\n          if (!["env", "props"].includes(key)) {\n            let oldBranch = oldTree?.instance.children[component.instance.children.length];\n            const instanceElement = this.serializeObjectChild(\n              instance,\n              { type: "item", value: key, childIndex: component.instance.children.length },\n              0,\n              "instance",\n              instancePath,\n              oldBranch,\n              oldTree\n            );\n            if (instanceElement) {\n              component.instance.children.push(instanceElement);\n            }\n          }\n        });\n      // Load instance getters\n      obj = Object.getPrototypeOf(instance);\n      while (obj) {\n        Reflect.ownKeys(obj).forEach((key) => {\n          if (\n            key !== "__proto__" &&\n            Object.getOwnPropertyDescriptor(obj, key).hasOwnProperty("get")\n          ) {\n            let child = {\n              name: key,\n              depth: 0,\n              toggled: false,\n              objectType: "instance",\n              path: [\n                ...instancePath,\n                {\n                  type: "prototype getter",\n                  value: key,\n                  childIndex: component.instance.children.length,\n                },\n              ],\n              contentType: "getter",\n              content: "(...)",\n              hasChildren: false,\n              children: [],\n            };\n            component.instance.children.push(child);\n          }\n        });\n        obj = Object.getPrototypeOf(obj);\n      }\n      const instancePrototype = this.serializeObjectChild(\n        instance,\n        { type: "prototype", childIndex: component.instance.children.length },\n        0,\n        "instance",\n        instancePath,\n        oldTree?.instance[component.instance.children.length],\n        oldTree\n      );\n      component.instance.children.push(instancePrototype);\n\n      // Load subscriptions of the component\n      if (isApp) {\n        component.subscriptions = {\n          toggled: oldTree ? oldTree.subscriptions.toggled : true,\n          children: [],\n        };\n      } else {\n        const rawSubscriptions = this.topLevelSubscriptions(node);\n        component.subscriptions = {\n          toggled: oldTree ? oldTree.subscriptions.toggled : true,\n          children: [],\n        };\n        rawSubscriptions.forEach((rawSubscription) => {\n          let subscription = {\n            target: {\n              name: this.targetName(rawSubscription.target, node),\n              contentType:\n                typeof rawSubscription.target === "object"\n                  ? Array.isArray(rawSubscription.target)\n                    ? "array"\n                    : "object"\n                  : rawSubscription.target,\n              depth: 0,\n              path: [\n                ...path,\n                { type: "item", value: "subscriptions" },\n                { type: "item", value: rawSubscription.index },\n                { type: "item", value: "target" },\n              ],\n              toggled: false,\n              objectType: "subscription",\n            },\n          };\n          if (\n            oldTree &&\n            oldTree.subscriptions.children[rawSubscription.index] &&\n            oldTree.subscriptions.children[rawSubscription.index].target.toggled\n          ) {\n            subscription.target.toggled = true;\n          }\n          if (rawSubscription.target == null) {\n            if (subscription.target.contentType === "undefined") {\n              subscription.target.content = "undefined";\n            } else {\n              subscription.target.content = "null";\n            }\n            subscription.target.hasChildren = false;\n          } else {\n            subscription.target.content = this.serializer.serializeContent(\n              rawSubscription.target,\n              subscription.target.contentType\n            );\n            subscription.target.hasChildren =\n              subscription.target.contentType === "object"\n                ? Object.keys(rawSubscription.target).length > 0\n                : subscription.target.contentType === "array"\n                ? rawSubscription.target.length > 0\n                : false;\n          }\n          subscription.target.children = [];\n          if (subscription.target.toggled) {\n            subscription.target.children = this.loadObjectChildren(\n              subscription.target.path,\n              subscription.target.depth,\n              subscription.target.contentType,\n              subscription.target.objectType,\n              oldTree\n            );\n          }\n          this.addHighlightedKeys(subscription.target);\n          component.subscriptions.children.push(subscription);\n        });\n      }\n      // Load hooks of the component\n      if (!isApp) {\n        component.hooks = { toggled: oldTree ? oldTree.hooks.toggled : true, children: [] };\n        const hooksList = [\n          "mounted",\n          "patched",\n          "willDestroy",\n          "willPatch",\n          "willStart",\n          "willUnmount",\n          "willUpdateProps",\n        ];\n        const hooksPath = [...instancePath, { type: "item", value: "__redom__" }];\n        Reflect.ownKeys(instance.__redom__)\n          .sort(compareKeys)\n          .forEach((key) => {\n            if (hooksList.includes(key)) {\n              let oldBranch = oldTree?.hooks.children[component.hooks.children.length];\n              const property = this.serializeObjectChild(\n                instance.__redom__,\n                { type: "item", value: key, childIndex: component.hooks.children.length },\n                0,\n                "hook",\n                hooksPath,\n                oldBranch,\n                oldTree\n              );\n              if (property) {\n                component.hooks.children.push(property);\n              }\n            }\n          });\n      }\n      return component;\n    }\n    // Replace the content of a parsed getter object with the result of the corresponding get method\n    loadGetterContent(getter) {\n      let obj = this.getObjectProperty(getter.path);\n      if (obj == null) {\n        if (typeof obj === "undefined") {\n          getter.content = "undefined";\n          getter.contentType = "undefined";\n        } else {\n          getter.content = "null";\n          getter.contentType = "object";\n        }\n        getter.hasChildren = false;\n      } else {\n        obj = this.toRaw(obj);\n        switch (true) {\n          case obj instanceof Map:\n            getter.contentType = "map";\n            getter.hasChildren = obj.size > 0;\n            break;\n          case obj instanceof Set:\n            getter.contentType = "set";\n            getter.hasChildren = obj.size > 0;\n            break;\n          case obj instanceof Array:\n            getter.contentType = "array";\n            getter.hasChildren = obj.length > 0;\n            break;\n          case typeof obj === "function":\n            getter.contentType = "function";\n            getter.hasChildren = Reflect.ownKeys(obj).length > 0;\n            break;\n          case obj instanceof Object:\n            getter.contentType = "object";\n            getter.hasChildren = Reflect.ownKeys(obj).length > 0;\n            break;\n          default:\n            getter.contentType = typeof obj;\n            getter.hasChildren = false;\n        }\n        getter.content = this.serializer.serializeContent(obj, getter.contentType);\n      }\n      return getter;\n    }\n    // Gives the DOM elements which correspond to the given component node\n    getDOMElementsRecursive(node) {\n      if (node.hasOwnProperty("bdom")) {\n        return this.getDOMElementsRecursive(node.bdom);\n      }\n      if (node.hasOwnProperty("content")) {\n        return this.getDOMElementsRecursive(node.content);\n      }\n      if (node.hasOwnProperty("el")) {\n        if (node.el instanceof Element || node.el instanceof Text) {\n          return [node.el];\n        }\n      }\n      if (node.hasOwnProperty("child")) {\n        return this.getDOMElementsRecursive(node.child);\n      }\n      if (node.hasOwnProperty("children") && node.children.length > 0) {\n        let elements = [];\n        for (const child of node.children) {\n          if (child) {\n            elements = elements.concat(this.getDOMElementsRecursive(child));\n          }\n        }\n        if (elements.length > 0) {\n          return elements;\n        }\n      }\n      if (node.hasOwnProperty("parentEl")) {\n        if (node.parentEl instanceof Element) {\n          return [node.parentEl];\n        }\n      }\n      return [];\n    }\n    // Triggers the highlight effect around the specified component.\n    highlightComponent(path) {\n      // Try to highlight the root component of the app if function called on an app\n      if (path.length === 1) {\n        path.push("root");\n      }\n      let component = this.getComponentNode(path);\n      if (!component) {\n        return;\n      }\n      const elements = this.getDOMElementsRecursive(component);\n      this.highlightElements(elements, component.component.constructor.name);\n    }\n    // Edit a reactive state property with the provided value of the given component (path) and the subscription path\n    editObject(path, value, objectType) {\n      if (value === "undefined") {\n        value = undefined;\n      } else {\n        try {\n          value = JSON.parse(value);\n        } catch (e) {\n          console.warn("Could not evaluate user property\\n", e);\n          return;\n        }\n      }\n      const item = path.pop();\n      const obj = this.getObjectProperty(path);\n      const key = item.hasOwnProperty("symbolIndex")\n        ? Object.getOwnPropertySymbols(obj)[item.symbolIndex]\n        : item.value;\n      if (!obj) {\n        return;\n      }\n      if (objectType === "subscription") {\n        this.reactive(obj)[key] = value;\n      } else {\n        obj[key] = value;\n        if (objectType === "props" || objectType === "instance") {\n          const component = this.getComponentNode(path);\n          if (component.__proto__.hasOwnProperty("render")) {\n            this.getComponentNode(path).render();\n          } else {\n            component.root.render();\n          }\n        } else if (objectType === "env") {\n          [...this.apps][path[0]].root.render(true);\n        }\n      }\n    }\n    // Recursively checks if the given html element corresponds to a component in the components tree.\n    // Immediatly returns the path of the first component which matches the element\n    searchElement(node, path, element) {\n      if (!node?.bdom) {\n        return null;\n      }\n      const results = this.getDOMElementsRecursive(node);\n      let hasElementInChildren = false;\n      for (const result of results) {\n        if (result.isEqualNode(element)) {\n          return path;\n        }\n        if (result.contains(element)) {\n          hasElementInChildren = true;\n        }\n      }\n      if (hasElementInChildren) {\n        for (const [key, child] of Object.entries(node.children)) {\n          const result = this.searchElement(child, path.concat([key]), element);\n          if (result) {\n            return result;\n          }\n        }\n      }\n      return null;\n    }\n    // Returns the path to the component which is currently being inspected\n    getElementPath(element) {\n      if (element) {\n        // Create an array with the html element and all its successive parents\n        const parentsList = [element];\n        if (element.tagName !== "BODY") {\n          while (element && element?.parentElement?.tagName !== "BODY") {\n            element = element.parentElement;\n            parentsList.push(element);\n          }\n        }\n        const appsArray = [...this.apps];\n        // Try to find a correspondance between the elements in the array and the redom component, stops at first result found\n        for (const elem of parentsList) {\n          for (const [index, app] of appsArray.entries()) {\n            const inspectedPath = this.searchElement(app.root, ["root"], elem);\n            if (inspectedPath) {\n              inspectedPath.unshift(index.toString());\n              return inspectedPath;\n            }\n          }\n        }\n      }\n      // If nothing was found, return the path of the first root component found in the apps\n      const appIndex = [...this.apps].findIndex((app) => app.root);\n      return [appIndex.toString(), "root"];\n    }\n    // Returns the tree of components of the inspected page in a parsed format\n    // Use inspectedPath to specify the path of the selected component\n    getComponentsTree(inspectedPath = null, oldTrees = null, oldDetails = null) {\n      const appsArray = [...this.apps];\n      if (inspectedPath && !this.getComponentNode(inspectedPath)) {\n        inspectedPath = null;\n      }\n      const trees = appsArray.map((app, index) => {\n        let oldTree;\n        if (oldTrees) {\n          oldTree = oldTrees[index];\n        }\n        let appNode = {};\n        appNode = {\n          name: app?.name ? `App (${app.name})` : "App " + (index + 1),\n          path: [index.toString()],\n          key: "",\n          depth: 0,\n          toggled: true,\n          selected: false,\n          highlighted: false,\n          version: app.__proto__.constructor?.version\n            ? app.__proto__.constructor.version\n            : "<2.0.8",\n          children: [],\n        };\n        if (app.root) {\n          const root = {\n            name: app.root.component.constructor.name,\n            path: [index.toString(), "root"],\n            key: "",\n            depth: 1,\n            toggled: true,\n            selected: false,\n            highlighted: false,\n          };\n          if (oldTree) {\n            appNode.toggled = oldTree.toggled;\n            oldTree = oldTree.children[0];\n          }\n          if (oldTree) {\n            root.toggled = oldTree.toggled;\n          }\n          // If no path is provided, it defaults to the target of the inspect element action\n          if (!inspectedPath) {\n            inspectedPath = this.getElementPath($0);\n          }\n          if (inspectedPath.join("/") === index.toString()) {\n            appNode.selected = true;\n            root.highlighted = true;\n          } else if (inspectedPath.join("/") === index.toString() + "/root") {\n            root.selected = true;\n          }\n          root.children = this.fillTree(app.root, root, inspectedPath.join("/"), oldTree);\n          appNode.children.push(root);\n        }\n        return appNode;\n      });\n      const component = this.getComponentDetails(inspectedPath, oldDetails);\n      return trees ? [trees, component] : [];\n    }\n    // Recursively fills the components tree as a parsed version\n    fillTree(appNode, treeNode, inspectedPathString, oldBranch) {\n      const children = [];\n      for (const [key, appChild] of Object.entries(appNode.children)) {\n        let child = {\n          name: appChild.component.constructor.name,\n          key: key,\n          depth: treeNode.depth + 1,\n          toggled: true,\n          selected: false,\n          highlighted: false,\n        };\n        child.path = treeNode.path.concat([child.key]);\n        let oldChild = null;\n        if (oldBranch) {\n          const searchResult = oldBranch.children.find((o) => o.key === key);\n          if (searchResult) {\n            oldChild = searchResult;\n            child.toggled = oldChild.toggled;\n          }\n        }\n        const childPathString = child.path.join("/");\n        if (childPathString === inspectedPathString) {\n          child.selected = true;\n        } else if (childPathString.includes(inspectedPathString)) {\n          child.highlighted = true;\n        }\n        child.children = this.fillTree(appChild, child, inspectedPathString, oldChild);\n        children.push(child);\n      }\n      return children;\n    }\n    getObservedVariables(current) {\n      const res = [...current];\n      for (let i = 0; i < current.length; i++) {\n        const path = current[i].path;\n        const parent = this.getObjectProperty(path.slice(0, path.length - 1));\n        if (parent && !(typeof parent === "string" && parent.startsWith("Exception: "))) {\n          const result = this.serializeObjectChild(\n            parent,\n            path.at(-1),\n            0,\n            "observed",\n            path.slice(0, path.length - 1),\n            {},\n            {}\n          );\n          result.hasChildren = false;\n          result.visible = true;\n          const index = path.findIndex((key) => typeof key !== "string");\n          if (index > 1) {\n            const componentNode = this.getComponentNode(path.slice(0, index));\n            result.path = [this.getComponentSimplifiedPath(componentNode)].concat(\n              path.slice(index)\n            );\n          }\n          res[i] = result;\n        } else {\n          res[i].visible = false;\n        }\n      }\n      return res;\n    }\n    // Returns the path of the given component node\n    getComponentPath(componentNode) {\n      let path = [];\n      if (componentNode.parentKey) {\n        path = [componentNode.parentKey];\n        while (componentNode.parent && componentNode.parent.parentKey) {\n          componentNode = componentNode.parent;\n          path.unshift(componentNode.parentKey);\n        }\n      }\n      path.unshift("root");\n      const appsArray = [...this.apps];\n      let index = appsArray.findIndex((app) => app === componentNode.app);\n      path.unshift(index.toString());\n      return path;\n    }\n    // Returns the simplified path of the given component node (using component names and indexes)\n    getComponentSimplifiedPath(componentNode) {\n      let path = componentNode.name;\n      if (componentNode.parentKey) {\n        while (componentNode.parent) {\n          const previousKey = componentNode.parentKey;\n          componentNode = componentNode.parent;\n          path = `${componentNode.name}/${Reflect.ownKeys(componentNode.children).indexOf(\n            previousKey\n          )}/${path}`;\n        }\n      }\n      const appsArray = [...this.apps];\n      let index = appsArray.findIndex((app) => app === componentNode.app);\n      path = index.toString() + (path.length ? `/${path}` : "");\n      return path;\n    }\n    // Store the object into a temp window variable and log it to the console\n    sendObjectToConsole(path) {\n      const obj = this.getObjectProperty(path);\n      let index = 1;\n      while (window["temp" + index] !== undefined) {\n        index++;\n      }\n      window["temp" + index] = obj;\n      console.log("temp" + index + " = ", window["temp" + index]);\n    }\n    // Inspect the DOM of the component in the elements tab of the devtools\n    inspectComponentDOM(path) {\n      const componentNode = this.getComponentNode(path);\n      const elements = this.getDOMElementsRecursive(componentNode);\n      if (IS_FIREFOX) {\n        window.$temp = elements[0];\n      } else {\n        inspect(elements[0]);\n      }\n    }\n    // Inspect the DOM of the component in the elements tab of the devtools\n    inspectComponentCompiledTemplate(path) {\n      const componentNode = this.getComponentNode(path);\n      const template = componentNode.component.constructor.template;\n      if (IS_FIREFOX) {\n        window.$temp = componentNode.app.templates[template];\n      } else {\n        inspect(componentNode.app.templates[template]);\n      }\n    }\n    // Inspect source code of the component (corresponds to inspecting its constructor)\n    inspectComponentRawTemplate(path) {\n      const componentNode = this.getComponentNode(path);\n      const template = componentNode.component.constructor.template;\n      const templateNode = componentNode.app.rawTemplates[template];\n      console.log(templateNode);\n    }\n    // Inspect source code of the function given by its path\n    inspectFunctionSource(path) {\n      const obj = this.getObjectProperty(path);\n      if (IS_FIREFOX) {\n        window.$temp = obj;\n      } else {\n        inspect(obj);\n      }\n    }\n\n    injectBreakpoint(hook, path, instanceOnly, condition) {\n      const componentNode = this.getObjectProperty(path);\n      const injectFunctionInHook = (comp, hook, fn) => {\n        comp[hook].push(fn);\n      };\n      const originalHook = [...componentNode.component.__redom__[hook]];\n      injectFunctionInHook(componentNode.component.__redom__, hook, () => {\n        debugger;\n      });\n      if (!this.breakpointsHookMap.get([componentNode.component.__redom__, hook])) {\n        this.breakpointsHookMap.set([componentNode.component.__redom__, hook], originalHook);\n      }\n      if (!instanceOnly) {\n        const componentClass = componentNode.component.constructor;\n        const originalSetup = componentClass.prototype.setup;\n        if (!this.breakpointsClassMap.get(componentClass)) {\n          this.breakpointsClassMap.set(componentClass, originalSetup);\n        }\n        componentClass.prototype.setup = function () {\n          const debuggerFunc = () => {\n            if (eval(condition)) {\n              this;\n              debugger;\n            }\n          };\n          injectFunctionInHook(this.__redom__, hook, debuggerFunc);\n          originalSetup.call(this, ...arguments);\n        };\n      }\n    }\n\n    removeBreakpoints() {\n      for (const [component, setup] of this.breakpointsClassMap) {\n        component.prototype.setup = setup;\n      }\n      this.breakpointsClassMap.clear();\n      for (const [ref, originalHook] of this.breakpointsHookMap) {\n        ref[0][ref[1]] = originalHook;\n      }\n      this.breakpointsHookMap.clear();\n    }\n\n    targetName(target, node) {\n      // check on component\n      const { component } = node;\n      for (const [key, value] of Object.entries(component)) {\n        if (target === this.toRaw(value)) {\n          return key;\n        }\n      }\n      // check on props\n      for (const [key, value] of Object.entries(component.props)) {\n        if (target === this.toRaw(value)) {\n          return `props.${key}`;\n        }\n      }\n      return "[unknown]";\n    }\n\n    /**\n     * Removes subscriptions that are a direct child of another subscription:\n     * they will be reachable from the top level by expanding observed keys.\n     *\n     * @param {ComponentNode} node\n     * @returns {{ keys: PropertyKey[], target: unknown}[]} the top level\n     *  subscriptions of the node\n     */\n    topLevelSubscriptions(node) {\n      const subscriptions = node.subscriptions.map((s, index) => ({ ...s, index }));\n      const topLevelValues = new Set(Object.values(node.component).map((o) => this.toRaw(o)));\n      const toOmit = new Set(\n        subscriptions\n          .flatMap(({ keys, target }) => keys.map((k) => this.toRaw(target[k])))\n          .filter((obj) => !topLevelValues.has(obj))\n      );\n      return subscriptions.filter(({ target }) => !toOmit.has(target));\n    }\n\n    addHighlightedKeys(child) {\n      const { path } = child;\n      const subscriptionIndex = path.findIndex((item) => typeof item !== "string");\n      if (path[subscriptionIndex]?.value === "subscriptions") {\n        const node = this.getComponentNode(path.slice(0, subscriptionIndex));\n        // Add observed keys\n        const targetToKeys = new Map(node.subscriptions.map(({ keys, target }) => [target, keys]));\n        const target = this.getObjectProperty(child.path);\n        child.keys = targetToKeys.get(target)?.map((k) => String(k));\n      }\n    }\n  }\n\n  function compareKeys(a, b) {\n    const isSymbolA = typeof a === "symbol";\n    const isSymbolB = typeof b === "symbol";\n\n    if (isSymbolA && !isSymbolB) {\n      return 1; // Place Symbols at the end\n    } else if (!isSymbolA && isSymbolB) {\n      return -1; // Place non-Symbols at the beginning\n    } else {\n      return String(a).localeCompare(String(b), undefined, { numeric: true }); // Sort other keys alphabetically\n    }\n  }\n\n  function checkReDOMStatus() {\n    let redomStatus = 2;\n    if (!window.__REDOM__DEVTOOLS_GLOBAL_HOOK__) {\n      if (window.__REDOM_DEVTOOLS__ || window.redom?.App) {\n        redomStatus = 1;\n      } else {\n        // It seems that sending a 0 results in undefined at the other end for some reason\n        redomStatus = -1;\n      }\n    }\n    window.postMessage({ source: "redom-devtools", type: "redomStatus", data: redomStatus });\n  }\n\n  if (!window.__REDOM_DEVTOOLS__) {\n    let val;\n    const descriptor = Object.getOwnPropertyDescriptor(window, "__REDOM_DEVTOOLS__") || {\n      get() {\n        return val;\n      },\n      set(value) {\n        val = value;\n      },\n    };\n    Object.defineProperty(window, "__REDOM_DEVTOOLS__", {\n      get() {\n        return descriptor.get.call(this);\n      },\n      set(value) {\n        descriptor.set.call(this, value);\n        if (value?.Fiber !== undefined) {\n          window.__REDOM__DEVTOOLS_GLOBAL_HOOK__ = new ReDOMDevtoolsGlobalHook();\n        }\n        window.top.postMessage({ source: "redom-devtools", type: "FrameReady" });\n        checkReDOMStatus();\n      },\n    });\n    // Do note that the reload message is not sent on the top window so that it is not intercepted when originating\n    // from an iframe\n    window.postMessage({ source: "redom-devtools", type: "Reload" });\n  } else if (\n    window.__REDOM_DEVTOOLS__?.Fiber !== undefined &&\n    !window.__REDOM__DEVTOOLS_GLOBAL_HOOK__\n  ) {\n    window.__REDOM__DEVTOOLS_GLOBAL_HOOK__ = new ReDOMDevtoolsGlobalHook();\n    window.postMessage({ source: "redom-devtools", type: "Reload" });\n  }\n  // Listener that checks whether redom is available on the page and if it has the right version\n  window.addEventListener(\n    "message",\n    function (event) {\n      if (event.data.source === "redom-devtools-background" && event.data.type === "checkReDOMStatus") {\n        checkReDOMStatus();\n      }\n    },\n    false\n  );\n  checkReDOMStatus();\n  // Indicates whether the scripts loaded successfully or not (only useful when loaded with eval in iframes)\n  return window.__REDOM__DEVTOOLS_GLOBAL_HOOK__ !== undefined;\n})();\n',document.documentElement.appendChild(e),e.parentNode.removeChild(e)}
